﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

//BuildingController is responsible for controlling a singular building for mission purposes
public class BuildingController : MonoBehaviour
{
    /// <summary>
    /// Tries to get the mission "attached" to this building
    /// </summary>
    /// <returns>The mission attached to this building if successful, otherwise null</returns>
    public Mission GetMission()
    {
        Vector3Int worldPos = GameManager.Instance.BuildingsTilemap.WorldToCell(gameObject.transform.position);

        foreach(var tileInfoKeyPair in BuildingsManager.Instance.RoadBuildings)
        {
            if(tileInfoKeyPair.Value.IsOccupied)
            {
                if (tileInfoKeyPair.Value.BuildingGameObject != null)
                {
                    if (tileInfoKeyPair.Value.BuildingGameObject.transform.position == gameObject.transform.position)
                    {
                        //Found the building info, let's see if any of our generated missions are at its position

                        foreach (Mission mission in MissionsManager.Instance.GeneratedMissions.Values)
                        {
                            if (mission.MissionSpawnPosition == tileInfoKeyPair.Key)
                            {
                                //Found the mission, return it
                                return mission;
                            }
                        }
                    }
                }
            }
        }

        return null;
    }

    private void OnTriggerStay2D(Collider2D collision)
    {
        if (GameManager.Instance.GameState == Constants.GameState.Playing)
        {
            if (Input.GetKeyDown(Constants.InteractKeyCode))
            {
                if (collision.name == Constants.PlayerCarObjectName)
                {
                    Mission mission = GetMission();

                    if (mission != null)
                    {
                        //We've got a mission that the player wants to start, let's start it
                        MissionsManager.Instance.ShowMission(mission);
                    }
                }
            }
        }
    }
}
